package coreservlets.listeners;

import javax.servlet.*;

/** Proces nasuchujcy, ktry wykrywa atrybut 'stats'
 *  dodany do zasigu dania. Gdy atrybut taki zostanie dodany,
 *  proces nakazuje licznikowi RequestCounter wstrzymanie
 *  procesu zbierania danych o czstoci obsugi da.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class StopRequestCounter 
       implements ServletRequestAttributeListener {

  /** Jeeli do zasigu dania dodanoy zosta atrybut "stats",
   *  do procesu ServletRequestListener wysyane jest polecenie
   *  wstrzymania zbierania danych statystycznych o daniach.
   */
  public void attributeAdded(ServletRequestAttributeEvent event) {
    String attributeName = event.getName();
    if (attributeName.equals("stats")) {
      RequestCounter.setCountingFinished(true);
    }
  }

  public void attributeRemoved(ServletRequestAttributeEvent event) {
  }

  public void attributeReplaced(ServletRequestAttributeEvent event) {
  }
}
